#include "Skips.h"
#include "AddNamespace.h"

// Adds namespaces to files
String AddNamespace(String const &Src, String const &SpaceName)
{
	String Dest;
	int p = 0;
	char c;
	bool NameSpaceInserted = false;
	int NameSpaceIfIndent = 0;
	int IfIndent = 0;

	// repeat until not end of file
	while(Src[p])
	{
		// here, it's out of namespace;
		// at beginning skips al preprocessor directives and alike
		// but counting for #if/#endif nesting level

		// skips startin spaces/comments
		SkipSpacesAndComments(Src, p, Dest);
	
		// skips directives
		while(Src[p])
		{
			// skips comments and spaces
			SkipSpacesAndComments(Src, p, Dest);
			
			// gets the #if/#endif indent level
			if(Src.Mid(p, 3) == "#if")
				IfIndent++;
			else if(Src.Mid(p, 6) == "#endif")
				IfIndent--;
			
			if(
				Src[p] == '#'
				||	Src.Mid(p, 5) == "using"
//				||	Src.Mid(p, 6) == "extern"
//				||	Src.Mid(p, 7) == "DEFINE_"
			)
				SkipToEol(Src, p, Dest);
			else
				break;
		}
		
		// here it should be at code start, or end of file
		// if file contains only preprocessor directives
		if(Src[p])
		{
			// start of code, inserts namespace here
			// keeping track of #if indent level
			Dest.Cat(String("\nnamespace ") + SpaceName + " {\n");
			NameSpaceInserted = true;
			NameSpaceIfIndent = IfIndent;
			
			// copies till end of line
			SkipToEol(Src, p, Dest);
			
			// copies all lines to output, checking for
			// #includes inside code
			while(Src[p])
			{
				// checks for nesting of #if/#endif
				if(Src.Mid(p, 3) == "#if")
					IfIndent++;
				else if(Src.Mid(p, 6) == "#endif" || Src.Mid(p, 5) == "#else")
				{
					// going back further of namespace if indent level ?
					if(NameSpaceIfIndent == IfIndent)
					{
						// yes, must first close namespace
						Dest.Cat(String("\n} // END namespace ") + SpaceName + "\n\n");
						NameSpaceInserted = false;
						NameSpaceIfIndent = 0;
						
						// then break inner loop, must start again
						break;
					}
					else if(Src.Mid(p, 6) == "#endif")
						IfIndent--;
				}
				
				// if #include, adds namespace closing and opening around
				if(Src.Mid(p, 8) == "#include")
				{
					// closing namespace
					Dest.Cat(String("\n} // END namespace ") + SpaceName + "\n\n");
					SkipToEol(Src, p, Dest);
					Dest.Cat(String("\nnamespace ") + SpaceName + " {\n");
				}
				else
					// copies till end of line
					SkipToEol(Src, p, Dest);
			}
		}
	}

	// if still has namespace inserted, must close it
	if(NameSpaceInserted)
	{
		// inserts closing namespace
		Dest.Cat(String("\n} // END namespace ") + SpaceName + "\n");
	}
	
	// adds \0 terminator
	Dest.Cat(0);
	
	return Dest;
	
} // END AddNamespace()
